<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Configuration;

/**
 * Class ActiveConfig
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Configuration
 */
class ActiveConfig
{
    /**
     * @var bool
     */
    protected $active = false;
    /**
     * @var string
     */
    protected $processingPath;

    /**
     * ActiveConfig constructor.
     *
     * @param array $configuration
     */
    public function __construct(array $configuration)
    {
        if (isset($configuration['processingactive'])) {
            $this->active = $configuration['processingactive'];
        }
        if (isset($configuration['processingpath'])) {
            $this->processingPath = $configuration['processingpath'];
        }
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * @return string
     */
    public function getProcessingPath(): string
    {
        return $this->processingPath;
    }
}
