<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\DependencyInjection;

use Lifestyle\Pimcore\AssignProductImagesBundle\Configuration\ActiveConfig;
use Lifestyle\Pimcore\AssignProductImagesBundle\Configuration\PictureTypeConfig;
use Lifestyle\Pimcore\AssignProductImagesBundle\Configuration\PictureTypesList;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class AssignProductImagesExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        $container->getDefinition(ActiveConfig::class)->setArgument(0, $config);

        if ($container->hasDefinition(PictureTypesList::class)) {
            $definition = $container->getDefinition(PictureTypesList::class);

            foreach ($config['picturetypes'] as $pictureType => $pictureTypeConfig) {
                $pictureTypeConfig['processingpath'] = $config['processingpath'];
                $pictureTypeConfig['targetpath'] = $config['targetpath'];
                $pictureTypeDefinition = new Definition(PictureTypeConfig::class, [$pictureType, $pictureTypeConfig]);
                $definition->addMethodCall('addPictureType', [$pictureTypeDefinition]);
            }
        }
    }
}
