<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Controller;

use Pimcore\Controller\FrontendController;
use Pimcore\Event\AssetEvents;
use Pimcore\Event\Model\AssetEvent;
use Pimcore\Model\Asset;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class AssignProductImagesController
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Controller
 *
 * @Route("/admin/assignproductimages")
 */
class AssignProductImagesController extends FrontendController
{
    /**
     * @param Request $request
     *
     * @return JsonResponse
     *
     * @Route("/asset/reassign/{assetId}")
     */
    public function assetReassignAction(Request $request, string $assetId)
    {
        Asset::getById($assetId, true)->save();

        return new JsonResponse([
            'success' => true
        ]);
    }
}
