<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Configuration;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class PictureTypesList
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Configuration
 */
class PictureTypesList
{
    /**
     * @var ArrayCollection|PictureTypeConfig[]
     */
    protected $pictureTypes;

    /**
     * PictureTypesList constructor.
     */
    public function __construct()
    {
        $this->pictureTypes = new ArrayCollection();
    }

    /**
     * @param PictureTypeConfig $pictureTypeConfig
     */
    public function addPictureType(PictureTypeConfig $pictureTypeConfig)
    {
        $this->pictureTypes->set($pictureTypeConfig->getName(), $pictureTypeConfig);
    }

    /**
     * @param string $pictureType
     *
     * @return bool
     */
    public function hasPictureType(string $pictureType)
    {
        return $this->pictureTypes->containsKey($pictureType);
    }

    /**
     * @param string $pictureType
     *
     * @return PictureTypeConfig
     */
    public function getPictureTypeConfig(string $pictureType)
    {
        return $this->pictureTypes->get($pictureType);
    }
}
