<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Services\AssetTypeHandler;

/**
 * Class AssetTypeHandlerFactory
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Services\AssetTypeHandler
 */
class AssetTypeHandlerFactory
{
    /**
     * @var AssetTypeGalleryHandler
     */
    protected $gallery;

    /**
     * AssetTypeHandlerFactory constructor.
     *
     * @param AssetTypeGalleryHandler $gallery
     */
    public function __construct(AssetTypeGalleryHandler $gallery)
    {
        $this->gallery = $gallery;
    }

    /**
     * @param string $type
     *
     * @return AssetTypeHandlerInterface
     */
    public function getByType(string $type): AssetTypeHandlerInterface
    {
        if (!property_exists($this, $type)) {
            throw new AssetTypeHandlerNotDefinedException('Handler type ' . $type . 'not defined!');
        }

        return $this->{$type};
    }
}
