<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Services\AssetTypeHandler;

use Lifestyle\Pimcore\AssignProductImagesBundle\Configuration\PictureTypeConfig;
use Pimcore\Event\Model\AssetEvent;

/**
 * Interface AssetTypeHandlerInterface
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Services\AssetTypeHandler
 */
interface AssetTypeHandlerInterface
{
    /**
     * @param AssetEvent        $assetEvent
     * @param PictureTypeConfig $pictureTypeConfig
     *
     * @return bool
     */
    public function process(AssetEvent $assetEvent, PictureTypeConfig $pictureTypeConfig): bool;

    /**
     * @param AssetEvent        $assetEvent
     * @param PictureTypeConfig $pictureTypeConfig
     *
     * @return bool
     */
    public function processDelete(AssetEvent $assetEvent, PictureTypeConfig $pictureTypeConfig): bool;
}
