# Assign Images Pimcore Plugin
 This bundle can be configured to automatically assign image assets (uploaded from admin or webdav) to an object's image gallery
 
 ## Requirements
 Pimcore 5
 
 ## Installation
The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "repositories": [
    ...
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/pim/pimcore5-assign-images.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle-pimcore-plugin/assign-product-images
```

## Configuration

##### Require the bundle in AppKernel.php
```php
    if (class_exists('\\Lifestyle\\Pimcore\\AssignProductImagesBundle\\AssignProductImagesBundle')) {
        $collection->addBundle(new \Lifestyle\Pimcore\AssignProductImagesBundle\AssignProductImagesBundle());
    }
```

##### Add some configuration to your config.yml
- processingactive: activate/deactivate the 
- processingpath: the processing upload path
- process_unpublished: switch between assigning to all or to published only
- targetpath: the target path to which the processed pictures are moved

##### You can add multiple picturetype configurations (see image name schema for picturetype keys)
- type: the data component type (currently only "gallery" for the media image gallery)
- object: the name of the target object class
- property: the property name of the data component assigned to the target object class
- metadata: optional metadata (name: value) that will be assigned to the asset custom metadata
- subfolder: define object properties as subfolder values (subfolders will be created in targetpath)

##### Example:
```yaml
assign_product_images:
    processingactive: '%env(bool:IMAGE_PROCESSINGACTIVE)%'
    processingpath: '%env(IMAGE_PROCESSINGPATH)%'
    process_unpublished: '%env(bool:IMAGE_PROCESS_UNPUBLISHED)%'
    targetpath: '%env(IMAGE_TARGETPATH)%'
    picturetypes:
        typea: # picture type name. see image name schema
            type: 'gallery'
            object: 'ObjectClassName1'
            property: 'GalleryName'
            subfolder:
              - 'ObjectProperty1'
        typeb:
            type: 'gallery'
            object: 'ObjectClassName2'
            property: 'GalleryName'
            metadata:
                namea: 0
                nameb: 'Bild'
```

## Image name schema

{targetObjectName}-{pictureType}{position}.{fileType}

- targetObjectName: the pimcore object key (as displayed in the data objects tree)
- pictureType: a picturetypes key from yaml config
- position: the picture position in the gallery

Example:

ABC12345-typea1.png

## Events

- assignimages.asset.postAssign: Event is triggered after the asset was successfully assigned to the object.
- assignimages.asset.postUnassign: Event is triggered after the asset was successfully deleted and removed from the object.
