<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2020 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Command;

use Lifestyle\Pimcore\AssignProductImagesBundle\Configuration\ActiveConfig;
use Pimcore\Model\Asset;
use Pimcore\Model\DataObject\AbstractObject;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Command\LockableTrait;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ImageReassignByTimestampCommand
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Command
 */
class ImageReassignByTimestampCommand extends Command
{
    private const LOCK_ID = 'imageReassignByTimestampCommand';

    use LockableTrait;

    /**
     * @var string
     */
    protected static $defaultName = 'lifestyle:image:reassignbytimestamp';

    /**
     * @var ActiveConfig
     */
    protected $activeConfig;

    /**
     * ImageReassignByTimestampCommand constructor.
     *
     * @param ActiveConfig $activeConfig
     */
    public function __construct(ActiveConfig $activeConfig)
    {
        $this->activeConfig = $activeConfig;

        parent::__construct();
    }

    /**
     * @inheritdoc
     */
    protected function configure()
    {
        $this
            ->addOption(
                'from',
                'f',
                InputOption::VALUE_REQUIRED,
                'Timestamp from. Required. No default'
            )
            ->addOption(
                'to',
                't',
                InputOption::VALUE_OPTIONAL,
                'Timestamp to. Optional. Defaults to current timestamp',
                time()
            )
        ;
    }

    /**
     * @inheritDoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if ($this->lock(self::LOCK_ID)) {
            AbstractObject::setHideUnpublished(false);
            $folder = Asset::getByPath('/' . $this->activeConfig->getTargetPath());

            $assets = new Asset\Listing();
            $conditions = [
                'path LIKE ' . $assets->quote($folder->getRealFullPath() . '/%'),
                'AND modificationDate BETWEEN ' . $input->getOption('from'). ' AND ' . $input->getOption('to'),
                'AND type = "image"'
            ];
            $assets->setCondition(implode(' ', $conditions));

            foreach ($assets as $asset) {
                try {
                    $output->writeln($asset->getFilename());
                    $asset->save();
                } catch (\Exception $exception) {
                    $output->writeln($exception->getMessage());
                }
            }

            $this->release();
        }
    }
}
