<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    r.stetter
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Model;

use Pimcore\Model\Asset;

/**
 * Class AssetInfo
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Model
 */
class AssetInfo
{
    /**
     * @var string
     */
    protected $objectKey;
    /**
     * @var string
     */
    protected $picturePosition;
    /**
     * @var string
     */
    protected $pictureType;
    /**
     * @var string
     */
    protected $originalName;
    /**
     * @var string
     */
    protected $moodTypeId;

    /**
     * AssetInfo constructor.
     *
     * @param Asset $asset
     */
    public function __construct(Asset $asset)
    {
        $assetNameInfo = pathinfo($asset->getFilename());
        $parts = explode('-', $assetNameInfo['filename']);
        // use last part as pictureAddition
        $pictureAddition = array_pop($parts);
        // rebuild object key from remaining parts
        $this->objectKey = implode('-', $parts);
        $this->picturePosition = preg_replace('/\D/', '', $pictureAddition);
        $this->pictureType = preg_replace('/\d/', '', $pictureAddition);
        $this->originalName = $asset->getFilename();
        $this->moodTypeId = $asset->getMetadata('moodTypeId') ?? '';
    }

    /**
     * @return string
     */
    public function getObjectKey(): string
    {
        return $this->objectKey;
    }

    /**
     * @return string
     */
    public function getPicturePosition(): string
    {
        return $this->picturePosition;
    }

    /**
     * @return string
     */
    public function getPictureType(): string
    {
        return $this->pictureType;
    }

    /**
     * @return string
     */
    public function getOriginalName(): string
    {
        return $this->originalName;
    }

    /**
     * @return string
     */
    public function getMoodTypeId(): string
    {
        return $this->moodTypeId;
    }
}
