<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Worker;

use Publikat\Pimcore\CopyDataSheetBundle\Api\Manager as ApiManager;

/***
 * Class Manager
 * @package Publikat\Pimcore\CopyDataSheetBundle\Worker
 */
class Manager
{
    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var []
     */
    private $factory;

    /**
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Copy
     */
    public function copy()
    {
        return isset($this->factory[__FUNCTION__]) ?
            $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Copy($this->apiM));
    }

    /**
     * @return CopyAsBulletPoints
     */
    public function copyAsBulletPoints()
    {
        return isset($this->factory[__FUNCTION__]) ?
            $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new CopyAsBulletPoints($this->apiM));
    }
}
