<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Worker;

use Publikat\Pimcore\CopyDataSheetBundle\Api\Manager as ApiManager;
use Pimcore\File;
use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\Folder;
use Pimcore\Model\Object\Data\BlockElement;
use Pimcore\Model\Version;

/***
 * Class CopyAsBulletPoints
 * @package Publikat\Pimcore\CopyDataSheetBundle\Worker
 */
class CopyAsBulletPoints
{
    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /***
     * @param $productGroupCode
     *
     * @return null|ArtikelFamilie
     */
    public function loadObject($productGroupCode)
    {
        $objectListing = null;

        $objectListing = new ArtikelFamilie\Listing();
        $objectListing->setCondition('o_key = ?', $productGroupCode);

        $response = null;

        if ($objectListing !== null) {
            $objectListing->load();

            /**
             * Object exists in PimCore
             */
            if ($objectListing->count() === 1) {
                $response = $objectListing->current();
            }
        }

        return $response;
    }


    /**
     * @param $productGroupCode
     *
     * @return string
     * @throws \ReflectionException
     */
    public function run($productGroupCode)
    {
        $articleFamily = $this->loadObject($productGroupCode);
        if (is_null($articleFamily)) {
            throw new \UnexpectedValueException('Kein Eintrag zu Artikelfamilie "' . $articleFamily . '" gefunden');
        }
        if ($articleFamily->getClass()->getName() !== 'ArtikelFamilie') {
            throw new \UnexpectedValueException('Ung&uuml;ltige Objekttypen!');
        }

        $pasteValues = [];
        $mapper = $this->apiM->mapper()->artikelFamilie($articleFamily);
        $translator = $this->apiM->translate()->translator();

        foreach ($mapper->getObjectProperties() as $propertyName) {

            if ('localizedfields' === $propertyName) {
                // Localized fields
                foreach ($mapper->getLocalizedValues('de') as $key => $value) {

                    if (strpos($key, 'datenblatt') === 0 && strlen(trim($value)) > 0) {
                        $pasteValues[] = [
                            'Text' => new BlockElement(
                                'Text',
                                'input',
                                trim($translator->trans($mapper->mapNameId($key))) . ' ' . $value
                            )
                        ];
                    }
                }
            } elseif (is_a($mapper->getValue($propertyName), '\Pimcore\Model\Object\Fieldcollection')) {
                // Field collection
                $fieldCollection = $mapper->getValue($propertyName);
                foreach ($fieldCollection->getItems() as $fieldCollectionData) {
                    // Field collection mapper
                    $fieldCollectionMapper = $this->apiM->mapper()->fieldCollection($fieldCollectionData);

                    // Field collection data - item
                    foreach ($fieldCollectionMapper->getValues() as $key => $values) {
                        if (strpos($key, 'datenblatt') === 0 && is_array($values)) {
                            $valuesTranslated = [];
                            foreach ($values as $value) {
                                $valuesTranslated[] = $translator->trans($value);
                            }

                            $pasteValues[] = [
                                'Text' => new BlockElement(
                                    'Text',
                                    'input',
                                    trim($translator->trans($mapper->mapNameId($key)))
                                    . ' '
                                    . implode(', ', $valuesTranslated)
                                )
                            ];
                        }
                    }
                }
            }
        }

        // STYLEFILE-5486 : Paste max five values. Version must be enabled first to save a version...
        $pasteValues = array_slice($pasteValues, 0 , 5, true);
        $articleFamily->setBulletPoints($pasteValues, 'de');
        Version::enable();
        $articleFamily->saveVersion();
        Version::disable();
        return 'true';
    }
}
