<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Mapper;

use Publikat\Pimcore\CopyDataSheetBundle\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\Datenblatt as ObjectDatenblatt;

/**
 * Mapper for project specific Object "Datenblatt"
 *
 * @package Publikat\Pimcore\CopyDataSheetBundle\Mapper
 */
class Datenblatt extends DataObject
{
    /**
     * @var ObjectDatenblatt
     */
    private $objectDatenblatt;

    /**
     * Datenblatt constructor.
     *
     * @param ApiManager       $apiM
     * @param ObjectDatenblatt $objectDatenblatt
     */
    public function __construct(ApiManager $apiM, ObjectDatenblatt $objectDatenblatt)
    {
        parent::__construct($apiM);
        $this->objectDatenblatt = $objectDatenblatt;
    }

    /**
     * @return ObjectDatenblatt
     */
    public function getObject()
    {
        return $this->objectDatenblatt;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {
        return preg_match('/^datenblatt/', $property) || 'localizedfields' == $property;
    }

    /**
     * Map name to name-id
     *
     * @param $name
     *
     * @return mixed
     */
    public function mapNameId($name)
    {
        return preg_replace('/^datenblatt(multi)?/i', '', $name);
    }
}
