<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @author:     Jochen Califice <info@life-style.de>
 * @link        www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Controller;

use Pimcore\Controller\FrontendController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Publikat\Pimcore\CopyDataSheetBundle\Api\Manager as ApiManager;

/**
 * Class XhrController
 *
 * @package Publikat\Pimcore\CopyDataSheetBundle\Controller
 */
class XhrController extends FrontendController
{
    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * XhrController constructor.
     *
     * @param ApiManager $apiManager
     */
    public function __construct(ApiManager $apiManager)
    {
        $this->apiManager = $apiManager;
    }


    /**
     * @param Request $request
     *
     * @return mixed
     *
     * @Route("/publikat_pimcore_copy_data_sheet_xhr_copyasbulletpoints")
     */
    public function copyAsBulletpointsAction(Request $request)
    {
        $jsonResponse = [
            'success' => false,
            'message' => '',
        ];
        try {
            $this->disableViewAutoRender($request);

            $productGroupCode = strtolower(trim(filter_input(INPUT_GET, 'productGroupCode')));
            if (empty($productGroupCode)) {
                throw new InvalidArgumentException('Parameter productGroupCode may not be empty!');
            }

            $status = $this->apiManager->worker()->copyAsBulletPoints()->run($productGroupCode);
            if ('true' === $status) {
                $jsonResponse = [
                    'success' => true,
                    'message' => 'Generierung erfolgreich! Seite wird neu geladen.',
                ];
            }
        } catch (\Exception $e) {
            $jsonResponse['message'] = $e->getMessage();
        }
        return $this->json($jsonResponse);
    }

    /**
     * @param Request $request
     *
     * @return mixed
     *
     * @Route("/publikat_pimcore_copy_data_sheet_xhr_copy")
     */
    public function copyAction(Request $request)
    {
        try {
            $this->disableViewAutoRender($request);
            $copyFrom = filter_input(INPUT_GET, 'copyFrom');
            $copyTo = filter_input(INPUT_GET, 'copyTo');
            if (empty($copyFrom) || empty($copyTo)) {
                throw new InvalidArgumentException('Values copyFrom or copyTo are empty!');
            }
            $status = $this->apiManager->worker()->copy()->run($copyFrom, $copyTo);
            if ('true' == $status) {
                return $this->json([
                    'success' => true,
                    'message' => 'Datenbl&auml;tter erfolgreich kopiert! Seite wird neu geladen.',
                ]);
            } else {
                return $this->json([
                    'success' => false,
                    'message' => $status,
                ]);
            }
        } catch (\Exception $e) {
            return $this->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
