<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Api;

use Publikat\Pimcore\CopyDataSheetBundle\Worker\Manager as WorkerManager;
use Publikat\Pimcore\CopyDataSheetBundle\Mapper\Factory as MapperFactory;
use Publikat\Pimcore\CopyDataSheetBundle\Translate\Manager as TranslateManager;
use Publikat\Pimcore\CopyDataSheetBundle\Pimcore\Manager as PimcoreManager;

/***
 * Class Manager
 * @package Publikat\Pimcore\CopyDataSheetBundle\Api
 */
class Manager
{
    /**
     * @var []
     */
    private $factory = [];

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ?
            $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return MapperFactory
     */
    public function mapper()
    {
        return isset($this->factory[__FUNCTION__]) ?
            $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new MapperFactory($this));
    }

    /**
     * @return TranslateManager
     */
    public function translate()
    {

        return isset($this->factory[__FUNCTION__]) ?
            $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslateManager($this));
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {

        return isset($this->factory[__FUNCTION__]) ?
            $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }
}
