<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Worker;

use Pimcore\Model\DataObject\AbstractObject;
use Publikat\Pimcore\CopyDataSheetBundle\Api\Manager as ApiManager;
use Pimcore\File;
use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\Folder;

/***
 * Class Copy
 * @package Publikat\Pimcore\CopyDataSheetBundle\Worker
 */
class Copy
{
    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param $articleFamilyCode
     *
     * @return null|ArtikelFamilie
     */
    public function loadObject($articleFamilyCode)
    {
        $objectListing = null;

        AbstractObject::setHideUnpublished(false);
        $objectListing = new ArtikelFamilie\Listing();
        $objectListing->setCondition('o_key = ?', File::getValidFilename($articleFamilyCode));

        $response = null;

        if ($objectListing !== null) {
            $objectListing->load();

            /**
             * Object exists in PimCore
             */
            if ($objectListing->count() === 1) {
                $response = $objectListing->current();
            }
        }

        return $response;
    }

    /**
     * @param $copyFrom
     * @param $copyTo
     *
     * @return string
     * @throws \ReflectionException
     */
    public function run($copyFrom, $copyTo)
    {
        $functionName = 'getDatenblatt';
        $copyFrom = trim(strtolower($copyFrom));
        $copyTo = trim(strtolower($copyTo));
        $articleFamilyFrom = $this->loadObject($copyFrom);
        $articleFamilyTo = $this->loadObject($copyTo);
        if ($copyFrom === $copyTo) {
            throw new \UnexpectedValueException('Als Ziel darf nicht die gleiche Artikelfamilie verwendet werden!');
        }
        if (is_null($articleFamilyFrom)) {
            throw new \UnexpectedValueException('Kein Eintrag zu Artikelfamilie "' . $copyFrom . '" gefunden');
        }
        if (is_null($articleFamilyTo)) {
            throw new \UnexpectedValueException('Kein Eintrag zu Artikelfamilie "' . $copyTo . '" gefunden');
        }
        if (($articleFamilyFrom->getClass() !== $articleFamilyTo->getClass())
            || ($articleFamilyFrom->getClass()->getName() !== 'ArtikelFamilie')
            || ($articleFamilyTo->getClass()->getName() !== 'ArtikelFamilie')
        ) {
            throw new \UnexpectedValueException('Ung&uuml;ltige Objekttypen!');
        }

        $pathFrom = $articleFamilyFrom->getRealPath();
        $pathTo = $articleFamilyTo->getRealPath();

        // copy only if paths are equal
        if ($pathFrom === $pathTo) {
            // crawl through all methods get/set of specific type
            $class = new \ReflectionClass('\Pimcore\Model\Object\ArtikelFamilie');
            $methods = $class->getMethods(\ReflectionMethod::IS_PUBLIC);
            foreach ($methods as $method) {
                if (strpos($method->getName(), $functionName) !== false) {
                    $field = substr($method->getName(), strlen($functionName));
                    $fromValue = $articleFamilyFrom->{$functionName . $field}();
                    $articleFamilyTo->{'setDatenblatt' . $field}($fromValue);
                }
            }
            $localizedFields = $articleFamilyFrom->getLocalizedfields();
            $articleFamilyTo->setLocalizedfields($localizedFields);
        } else {
            throw new \UnexpectedValueException(
                'Artikelfamilien befinden sich nicht im gleichen Verzeichnis!<br>' .
                strtoupper($copyFrom) . ': ' . $pathFrom . '<br>' .
                strtoupper($copyTo) . ': ' . $pathTo
            );
        }
        if (!is_null($pathTo)) {
            $articleFamilyTo->setPublished(false);
            $articleFamilyTo->save();
            return 'true';
        }

        return 'false';
    }
}
