<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

use CopyDataSheet\Api\Manager as ApiManager;

class CopyDataSheet_IndexController extends \Pimcore\Controller\Action\Admin
{
    /**
     * @var ApiManager
     */
    private $apiM;

    /**
     * @throws \Zend_Exception
     */
    public function init()
    {
        \Pimcore\Model\Version::disable();

        $this->apiM = Zend_Registry::get('plugins.copydatasheet.apimanager');
        parent::init();
    }

    /**
     * Get json helper
     * @return \Zend_Controller_Action_Helper_Json
     */
    private function json()
    {
        return $this->getHelper('json');
    }

    /**
     * http://pimcore.local/plugin/CopyDataSheet/index/copy?copyFrom=ca09007&copyTo=ac21002
     *
     * @return mixed
     * @throws \Exception
     */
    public function copyAction()
    {
        try {
            $this->disableViewAutoRender();
            $this->disableLayout();
            $copyFrom = filter_input(INPUT_GET, 'copyFrom');
            $copyTo = filter_input(INPUT_GET, 'copyTo');
            if (empty($copyFrom) || empty($copyTo)) {
                throw new InvalidArgumentException('Values copyFrom or copyTo are empty!');
            }
            $status = $this->apiM->worker()->copy()->run($copyFrom, $copyTo);
            if ($status) {
                $this->json()->sendJson([
                    'success' => true,
                    'message' => 'Datenbl&auml;tter erfolgreich kopiert! Seite wird neu geladen.',
                ]);
            } else {
                $this->json()->sendJson([
                    'success' => false,
                    'message' => $status,
                ]);
            }
        } catch (\Exception $e) {
            $this->json()->sendJson([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }

    /**
     * Does copy datasheet items as bullet point
     */
    public function copyasbulletpointsAction()
    {
        $jsonResponse = [
            'success' => false,
            'message' => '',
        ];
        try {
            $this->disableViewAutoRender();
            $this->disableLayout();

            $productGroupCode = strtolower(trim(filter_input(INPUT_GET, 'productGroupCode')));
            if (empty($productGroupCode)) {
                throw new InvalidArgumentException('Parameter productGroupCode may not be empty!');
            }

            $status = $this->apiM->worker()->copyAsBulletPoints()->run($productGroupCode);
            if ('true' === $status) {
                $jsonResponse = [
                    'success' => true,
                    'message' => 'Generierung erfolgreich! Seite wird neu geladen.',
                ];
            }
        } catch (\Exception $e) {
            $jsonResponse['message'] = $e->getMessage();
        }

        $this->json()->sendJson($jsonResponse);
    }
}
