<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace CopyDataSheet\Mapper;

use ReflectionClass;

/**
 * Base Mapper for Object- and Fieldcollection-Mapper
 *
 * @package CopyDataSheet\Mapper
 */
abstract class Base
{
    /**
     * @return array|\ReflectionProperty[]
     * @throws \ReflectionException
     */
    public function getObjectProperties()
    {
        $reflectionClass = new ReflectionClass(get_class($this->getObject()));
        $properties = $reflectionClass->getProperties();
        array_walk($properties, function (&$property) {

            $property = $property->getName();
        });

        return array_filter($properties, array($this, 'filterProperties'));
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    abstract protected function filterProperties($property);

    /**
     * @return object
     */
    abstract public function getObject();
}
