<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace CopyDataSheet\Mapper;

use CopyDataSheet\Api\Manager as ApiManager;
use Pimcore\Model\Object\ArtikelFamilie as ObjectArtikelFamilie;
use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;

/**
 * @package CopyDataSheet\Mapper
 */
class Factory
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Create new datenblatt-mapper
     *
     * @param ObjectFieldcollection $objectFieldCollection
     *
     * @return FieldCollection
     */
    public function fieldCollection(ObjectFieldcollection $objectFieldCollection)
    {
        return new FieldCollection($this->apiM, $objectFieldCollection);
    }

    /**
     * Create new article family mapper
     *
     * @param ObjectArtikelFamilie $objectArtikelFamilie
     *
     * @return ArtikelFamilie
     */
    public function artikelFamilie(ObjectArtikelFamilie $objectArtikelFamilie)
    {
        return new ArtikelFamilie($this->apiM, $objectArtikelFamilie);
    }
}
