<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace CopyDataSheet\Mapper;

use CopyDataSheet\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;

/**
 * Field-Collection-Mapper
 *
 * @package CopyDataSheet\Mapper
 */
class FieldCollection extends Base
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var ObjectFieldcollection
     */
    protected $fieldCollection;

    /**
     * FieldCollection constructor.
     *
     * @param ApiManager            $apiM
     * @param ObjectFieldcollection $objectFieldcollection
     */
    public function __construct(ApiManager $apiM, ObjectFieldcollection $objectFieldcollection)
    {

        $this->apiM = $apiM;
        $this->fieldCollection = $objectFieldcollection;
    }

    /**
     * @return array
     * @throws \ReflectionException
     */
    public function getValues()
    {

        $values = [];
        foreach ($this->getObjectProperties() as $property) {
            $method = 'get' . ucfirst($property);
            null !== ($value = $this->getObject()->$method()) ? $values[$property] = $value : null;
        }

        return $values;
    }

    /**
     * @return ObjectFieldcollection
     */
    public function getObject()
    {

        return $this->fieldCollection;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {
        return (boolean) (preg_match('/^datenblatt(Multi)?[A-Z]/', $property) || preg_match('/^clpVerordnung?[A-Z]/', $property));
    }
}
