<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace CopyDataSheet;

use Pimcore\API\Plugin as PluginLib;
use CopyDataSheet\Api\Manager as ApiManager;
use Doctrine\Common\Annotations\AnnotationRegistry;

/***
 * Class Plugin
 * @package CopyDatasheet
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{
    /**
     * @throws \Zend_EventManager_Exception_InvalidArgumentException
     */
    public function init()
    {
        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');
        $apiM = new ApiManager();
        // Register api manager
        \Zend_Registry::set('plugins.copydatasheet.apimanager', $apiM);
    }

    /***
     * @return bool
     */
    public static function install()
    {
        // implement your own logic here
        return true;
    }

    /***
     * @return bool
     */
    public static function uninstall()
    {
        // implement your own logic here
        return true;
    }

    /***
     * @return bool
     */
    public static function isInstalled()
    {
        // implement your own logic here
        return true;
    }
}
