var myForm = new Ext.form.Panel({
    bodyStyle: 'background:#fff; padding:10px;',
    applyTo: 'pimcore_body',
    defaultType: 'textfield',
    height: 200,
    width: 450,
    items: [{
        fieldLabel: 'Kopieren von',
        name: 'copyFrom',
        allowBlank: false,
        listeners: {
            change: function (obj, newValue) {
                obj.setRawValue(newValue.toUpperCase());
            }
        }
    }, {
        fieldLabel: 'Kopieren nach',
        name: 'copyTo',
        disabled: true,
        //value: 'DisplayCode',
        allowBlank: false
    }],
    buttons: [{
        text: 'Reset',
        handler: function () {
            this.up('form').getForm().setValues({copyFrom: ''});
        }
    }, {
        text: 'Kopieren',
        formBind: true, //only enabled once the form is valid
        disabled: true,
        style: 'margin-right:20px;',
        handler: function () {
            var form = this.up('form').getForm();
            Ext.Ajax.request({
                url: '/plugin/CopyDataSheet/index/copy',
                method: 'GET',
                params: {
                    copyFrom: form.findField('copyFrom').getValue(),
                    copyTo: form.findField('copyTo').getValue()
                },
                headers: {'Content-Type': 'application/json'},
                success: function (conn, response, options, eOpts) {
                    var data = Ext.decode(conn.responseText);
                    if (data) {
                        Ext.MessageBox.alert(data.success ? 'Erfolg!' : 'Fehler!', data.message);
                        if (data.success) {
                            ModalDialog.hide();
                            // reload object data
                            var tabpanel = Ext.getCmp('pimcore_panel_tabs');
                            var activeTab = tabpanel.getActiveTab();
                            activeTab.object.reload(activeTab.layout.id);
                        }
                    } else {
                        Ext.MessageBox.alert('Fehler!', 'Datenblatt konnte nicht kopiert werden!\r\n ' + data.message);
                    }
                },
                failure: function (conn, response, options, eOpts) {
                    Ext.MessageBox.alert('Fehler!', 'Datenblatt konnte nicht kopiert werden!');
                }
            });
        }
    }],
});

var ModalDialog = new Ext.Window({
    applyTo: 'pimcore_body',
    title: 'Datenblatt kopieren von Artikelfamilie',
    height: 250,
    width: 450,
    resizeable: false,
    closable: true,
    closeAction: 'hide',
    modal: true,
    layout: 'border',
    items: myForm
});

pimcore.registerNS("pimcore.plugin.copydatasheet");

pimcore.plugin.copydatasheet = Class.create(pimcore.plugin.admin, {
    getClassName: function () {
        return "pimcore.plugin.copydatasheet";
    },

    initialize: function () {
        pimcore.plugin.broker.registerPlugin(this);
    },

    pimcoreReady: function (params, broker) {
    },

    postOpenObject: function (doc) {
        var tabpanel = Ext.getCmp("pimcore_panel_tabs");
        var activeTab = tabpanel.getActiveTab();
        // show only on ArtikelFamilie
        if(activeTab.query('[name=DisplayCode]')[0] != null){
            doc.toolbar.insert(10, {
                iconCls: 'pimcore_icon_paste',
                text: 'Datenblatt kopieren',
                itemId: 'downloadHtml',
                scale: "medium",
                handler: function (button) {
                    var displayCode = activeTab.query('[name=DisplayCode]')[0].getValue();
                    myForm.getForm().setValues({copyTo: displayCode, copyFrom: ''});
                    ModalDialog.show();
                }.bind(doc)
            })
        }
    }
});

var copydatasheetPlugin = new pimcore.plugin.copydatasheet();

/**
 * STYLEFILE-5486 : Bulletpoints from data sheet
 */

pimcore.registerNS("pimcore.plugin.copydatasheetasbulletpoints");

pimcore.plugin.copydatasheetasbulletpoints = Class.create(pimcore.plugin.admin, {
    getClassName: function () {
        return "pimcore.plugin.copydatasheetasbulletpoints";
    },

    initialize: function () {
        pimcore.plugin.broker.registerPlugin(this);
    },

    pimcoreReady: function (params, broker) {
    },

    postOpenObject: function (doc) {
        var tabpanel = Ext.getCmp("pimcore_panel_tabs");
        var activeTab = tabpanel.getActiveTab();
        if (activeTab.query('[name=DisplayCode]')[0] != null) {
            doc.toolbar.insert(10, {
                iconCls: 'pimcore_icon_paste',
                text: 'Bulletpoints generieren',
                scale: "medium",
                handler: function(button) {

                    let productGroupCode = activeTab.query('[name=DisplayCode]')[0].getValue();

                    Ext.Ajax.request({
                        url: '/plugin/CopyDataSheet/index/copyAsBulletPoints',
                        method: 'GET',
                        params: {
                            productGroupCode: productGroupCode
                        },
                        headers: {'Content-Type': 'application/json'},
                        success: function (responseData) {
                            let data = Ext.decode(responseData.responseText);
                            if (data) {
                                if (data.success) {

                                    // reload object data
                                    var tabpanel = Ext.getCmp('pimcore_panel_tabs');
                                    var activeTab = tabpanel.getActiveTab();
                                    activeTab.object.reload(activeTab.layout.id);
                                }
                            } else {
                                Ext.MessageBox.alert('Fehler!', 'Daten konnten nicht generiert werden!\r\n ' + data.message);
                            }
                        },
                        failure: function () {
                            Ext.MessageBox.alert('Fehler!', 'Daten konnten nicht generiert werden!');
                        }
                    });

                }.bind(doc)
            })
        }
    }
});

var copydatasheetasbulletpointsPlugin = new pimcore.plugin.copydatasheetasbulletpoints();