<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\CopyDataSheetBundle\Mapper;

use Publikat\Pimcore\CopyDataSheetBundle\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\Fieldcollection;

/**
 * Data Object Mapper
 *
 * @package Publikat\Pimcore\CopyDataSheetBundle\Mapper
 */
abstract class DataObject extends Base
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param string $language
     *
     * @return array
     */
    public function getLocalizedValues($language)
    {
        $items = $this->getObject()->getLocalizedfields()->getInternalData();

        // No values for selected language
        if (!isset($items[$language])) {
            $this->apiM->logger()->info(sprintf('No localized fields for language %s in object %d', $language, $this->getObject()->getId()));

            return [];
        }

        // Get localized values
        $values = [];
        foreach (array_keys($items[$language]) as $name) {
            $value = $this->getObject()->getLocalizedfields()->getLocalizedValue($name, $language);
            if (null !== $value) {
                /*
                 * STYLEFILE-5458 : Some pimcore datatype values are available as arrays (e.g. bullet points as blocks)
                 */
                if (is_array($value)) {
                    foreach ($value as $index => $elements) {
                        foreach ($elements as $key => $data) {
                            if (!empty(trim($data->getData()))) {
                                $values[$name . $key . $index] = $data->getData();
                            }
                        }
                    }
                } else {
                    $values[$name] = $value;
                }
            }
        }
        return $values;
    }

    /**
     * @return array
     * @throws \ReflectionException
     */
    public function getValues()
    {
        $values = [];
        foreach ($this->getObjectProperties() as $property) {
            $method = 'get' . ucfirst($property);
            null !== ($value = $this->getObject()->$method()) ? $values[$property] = $value : null;
        }
        return $values;
    }

    /**
     * @param string $property
     *
     * @return mixed
     */
    public function getValue($property)
    {
        $method = 'get' . ucfirst($property);

        return $this->getObject()->$method();
    }
}
