<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link www.life-style.de
 */

namespace ExportArticleFamily\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

use ReflectionClass;

/**
 * Unit Tests
 *
 * @package ExportObjects\Tests
 * @author  Oliver Friedrich <of@life-style.de>
 */
class ConfigTest extends TestBase
{

    public function testPluginConfig()
    {

        $pluginConfig = $this->apiM()->pluginConfig();
        $this->assertInstanceOf('ExportArticleFamily\Config\PluginConfig', $pluginConfig);
        $clients = $pluginConfig->getClients();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $clients);
        if ($clients->count()) {
            $client = $clients->first();
            $this->assertInstanceOf('ExportArticleFamily\Config\Client', $client);
            $this->assertTrue(is_string($client->getId()));
            $this->assertTrue(is_bool($client->isActive()));
            $services = $client->getServices();
            $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $services);
            if ($services->count()) {
                $service = $services->first();
                $this->assertInstanceOf('ExportArticleFamily\Config\Service', $service);
                $this->assertTrue(is_string($service->getUrl()));
                $this->assertTrue(is_string($service->getName()));
            }
        }
    }


    public function testServiceConfig()
    {

        $pluginConfig = $this->apiM()->pluginConfig();
        $clients = $pluginConfig->getClients();
        if (!$clients->count()) {
            return;
        }
        $client = $clients->first();
        $services = $client->getServices();
        if (!$services->count()) {
            return;
        }
        $service = $services->first();

        // Test getter
        $this->assertTrue(is_string($service->getUrl()));
        $this->assertTrue(is_string($service->getName()));
        $this->assertTrue(is_string($service->getFormat()));
        $this->assertTrue(is_string($service->getContentType()));
        $this->assertTrue(is_string($service->getAcceptContentType()));

        // Delete url
        $reflectionClass = new ReflectionClass(get_class($service));
        $reflectionProperty = $reflectionClass->getProperty('url');
        $reflectionProperty->setAccessible(true);
        $reflectionProperty->setValue($service, '');

        // Set content type
        $reflectionProperty = $reflectionClass->getProperty('contentType');
        $reflectionProperty->setAccessible(true);
        $reflectionProperty->setValue($service, 'xml');

        // Test content type
        $this->assertTrue(is_string($service->getContentType()));
    }

}
