<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Config;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Service
 *
 * @package ExportArticleFamily\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Service")
 */
class Service
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Url")
     * @Serializer\Type("string")
     * @var string
     */
    private $url;

    /**
     * @Serializer\SerializedName("Format")
     * @Serializer\Type("string")
     * @var string xml|json
     */
    private $format;

    /**
     * @Serializer\SerializedName("ContentType")
     * @Serializer\Type("string")
     * @var string text/xml|application/json
     */
    private $contentType;

    /**
     * @return string
     */
    public function getName()
    {

        return $this->name;
    }

    /**
     * @return string
     */
    public function getUrl()
    {

        return $this->url;
    }

    /**
     * @return string
     */
    public function getFormat()
    {

        return preg_match('/\.(xml|json)$/', $this->url, $matches) ? $matches[1] : $this->format;
    }

    /**
     * @return string
     */
    public function getContentType()
    {

        if (preg_match('/\.(xml|json)$/', $this->url, $matches)) {
            return 'xml' == $matches[1] ? 'text/xml; charset=UTF-8' : 'application/json; charset=UTF-8';
        }

        return $this->contentType;
    }

    /**
     * @return string
     */
    public function getAcceptContentType()
    {

        return preg_replace('/;.+/', '', $this->getContentType());
    }

}
