<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Model;

use ExportArticleFamily\Api\Manager as ApiManager;
use ExportArticleFamily\Model\Credentials\Factory as CredentialsFactory;
use ExportArticleFamily\Model\Request\Objects\Delete\Factory as ObjectsDeleteFactory;
use ExportArticleFamily\Model\Request\Objects\Update\Factory as ObjectsUpdateFactory;

/**
 * Model-Manager
 *
 * @package ExportArticleFamily\Model
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $factory;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * @return ObjectsUpdateFactory
     */
    public function objectsUpdate()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ObjectsUpdateFactory($this->apiM));
    }

    /**
     * @return ObjectsDeleteFactory
     */
    public function objectsDelete()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ObjectsDeleteFactory($this->apiM));
    }
}
