<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Model\Request\Objects\Delete;

use ExportArticleFamily\Model\Request\RequestInterface;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Objects Delete Request
 *
 * @package ExportArticleFamily\Model\Request\Objects\Delete
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("StylefileProductRequest")
 */
class Request implements RequestInterface
{
    /**
     * @Serializer\SerializedName("Item")
     * @Serializer\Type("ArrayCollection<ExportArticleFamily\Model\Request\Objects\Delete\Item>")
     * @Serializer\XmlList(inline=true, entry="Item")
     * @var Item[]
     */
    private $items;

    /**
     * Request constructor.
     */
    public function __construct()
    {

        $this->items = new ArrayCollection();
    }

    /**
     * Add item to list
     *
     * @param Item $item
     *
     * @return Request
     */
    public function addItem(Item $item)
    {

        $this->items[] = $item;

        return $this;
    }

    /**
     * Delete empty items array
     *
     * @Serializer\PreSerialize
     */
    public function nullItems()
    {

        if (!count($this->items)) {
            $this->items = null;
        }
    }

    /**
     * @return $this
     */
    public function getRequest()
    {

        return $this;
    }

    /**
     * @return string
     */
    public function getResponseType()
    {

        return 'ExportArticleFamily\Model\Response\Objects\Delete\Response';
    }
}
