<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Worker;

use ExportArticleFamily\Api\Manager as ApiManager;
use Pimcore\Model\Object\ArtikelFamilie;
use ExportArticleFamily\Model\Request\Objects\Delete\Request;

/**
 * Delete Worker
 *
 * @package ExportArticleFamily\Worker
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Delete
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Run export
     *
     * @param ArtikelFamilie $object
     */
    public function run(ArtikelFamilie $object)
    {

        // Prepare request
        $modelRequest = $this->apiM->model()->objectsDelete()->request();

        // Prepare data
        $this->delete($modelRequest, $object);

        $this->apiM->logger()->debug(sprintf('Object "%s" (ID: %d) added to delete request',
            $object->getKey(),
            $object->getId()));

        // Send request
        foreach ($this->apiM->clients()->active() as $client) {
            $service = $this->apiM->clients()->service($client, 'Objects::Delete');
            $this->apiM->webservice()->request()->send($modelRequest, $client, $service);
        }
    }

    /**
     * @param Request        $request
     * @param ArtikelFamilie $object
     */
    private function delete(Request $request, ArtikelFamilie $object)
    {

        $item = $this->apiM->model()->objectsDelete()->item($request);
        $item->setProductId($object->getKey());
    }
}
