<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportArticleFamily\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Unit Tests
 *
 * @package ExportObjects\Tests
 * @author  Oliver Friedrich <of@life-style.de>
 */
class WorkerTest extends TestBase
{

    /**
     * @expectedException \ExportArticleFamily\Webservice\InvalidResponseException
     */
    public function testUpdate()
    {

        $apiM = $this->webserviceBuildApiM();
        $object = $this->getArtikelFamiliePublished();
        if ($object) {
            // Success 200
            $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
            $apiM->worker()->update()->run($object);

            // Error 400
            $this->webserviceAddResponse(400, array('Content-Type' => 'application/json'), $this->webserviceCreateError($apiM));
            $apiM->worker()->update()->run($object);
        }
    }

    /**
     * @expectedException \ExportArticleFamily\Webservice\InvalidResponseException
     */
    public function testDelete()
    {

        $apiM = $this->webserviceBuildApiM();
        $object = $this->getArtikelFamilieUnpublished();
        if ($object) {
            // Success 200
            $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
            $apiM->worker()->delete()->run($object);

            // Error 400
            $this->webserviceAddResponse(400, array('Content-Type' => 'application/json'), $this->webserviceCreateError($apiM));
            $apiM->worker()->delete()->run($object);
        }
    }

}
