<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily;

use Pimcore\API\Plugin as PluginLib;
use ExportArticleFamily\Api\Manager as ApiManager;
use Doctrine\Common\Annotations\AnnotationRegistry;
use Symfony\Component\VarDumper\VarDumper;
use Symfony\Component\VarDumper\Cloner\VarCloner;
use Symfony\Component\VarDumper\Dumper\CliDumper;

/**
 * Plugin Install
 *
 * @package ExportArticleFamily
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{
    /**
     * Init plugin
     */
    public function init()
    {

        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');

        $apiM = new ApiManager();
        $apiM->eventListener()->init();

        $this->initDump($apiM);
    }

    /**
     * @param ApiManager $apiM
     */
    private function initDump(ApiManager $apiM)
    {

        $logger = $apiM->logger();
        VarDumper::setHandler(function ($var) use ($logger) {

            $cloner = new VarCloner();
            $dumper = new CliDumper();
            $output = fopen('php://memory', 'r+b');

            $dumper->dump($cloner->cloneVar($var), $output);
            $logger->debug(stream_get_contents($output, -1, 0));
        });
    }

    /**
     * @return bool
     */
    public static function needsReloadAfterInstall()
    {

        return false;
    }

    /**
     * @return string
     */
    public static function install()
    {

        $path = self::getInstallPath();

        if (!is_dir($path)) {
            mkdir($path);
        }

        if (self::isInstalled()) {
            return "ExportArticleFamily Plugin successfully installed.";
        } else {
            return "ExportArticleFamily Plugin could not be installed.";
        }
    }

    /**
     * @return string
     */
    public static function uninstall()
    {

        rmdir(self::getInstallPath());

        if (!self::isInstalled()) {
            return "ExportArticleFamily Plugin successfully uninstalled.";
        } else {
            return "ExportArticleFamily Plugin could not be uninstalled.";
        }
    }

    /**
     * @return bool
     */
    public static function isInstalled()
    {

        return is_dir(self::getInstallPath());
    }

    /**
     * @param string $language
     *
     * @return null|string
     */
    public static function getTranslationFile($language)
    {

        return null;
    }

    /**
     * @return string
     */
    public static function getInstallPath()
    {

        return PIMCORE_PLUGINS_PATH . "/ExportArticleFamily/install";
    }

}
