<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\ValueMapper;

use ExportArticleFamily\Api\Manager as ApiManager;
use ExportArticleFamily\Config\Client;
use ExportArticleFamily\Config\Objects\Property as ConfigProperty;
use ExportArticleFamily\Mapper\ArtikelFamilie as ObjectMapper;

/**
 * Class LuminousFlux unit mapper (lm, lumen)
 *
 * @package ExportArticleFamily\ValueMapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class LuminousFlux extends Base
{
    /**
     * @var string
     */
    private $baseUnit;

    /**
     * Luminous Lux constructor.
     *
     * @param ApiManager $apiM
     * @param Client     $client
     */
    public function __construct(ApiManager $apiM, Client $client)
    {

        parent::__construct($apiM, $client);
        $this->validUnits = array(
            'lm' => 'lm',
            'lumen' => 'lm',
        );
        $this->baseUnit = $this->getUnit($client->getUnits()->getLuminousFlux()->getBase());
    }

    /**
     * Map value
     *
     * @param ObjectMapper   $objectMapper
     * @param ConfigProperty $property
     * @param string         $language
     *
     * @return mixed
     */
    public function map(ObjectMapper $objectMapper, ConfigProperty $property, $language)
    {

        $value = trim($this->getObjectValue($objectMapper, $property));

        // Do not map empty values
        if (!strlen($value)) {
            return '';
        }

        return (integer) preg_replace('/[^\d]+/', '', $value);
    }

}
