<?php
/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Config;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Objects Configuration
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Config
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Objects
{
    /**
     * @Serializer\SerializedName("Datenblatt")
     * @Serializer\Type("Publikat\Pimcore\ExportArticleFamilyBundle\Config\Objects\Datenblatt")
     * @var Objects\Datenblatt
     */
    private $datenblatt;

    /**
     * @Serializer\SerializedName("ArtikelFamilie")
     * @Serializer\Type("Publikat\Pimcore\ExportArticleFamilyBundle\Config\Objects\ArtikelFamilie")
     *
     * @var Objects\ArtikelFamilie
     */
    private $artikelFamilie;

    /**
     * @return Objects\ArtikelFamilie
     */
    public function getArtikelFamilie()
    {
        return $this->artikelFamilie;
    }

    /**
     * @return Objects\Datenblatt
     */
    public function getDatenblatt()
    {
        return $this->datenblatt;
    }
}
