<?php
/**
 * Short description for file
 *
 * Long description for file (if any)...
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Mapper;

use Pimcore\Log\ApplicationLogger;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\ArtikelFamilie as ObjectArtikelFamilie;

/**
 * Class ArtikelFamilie
 *
 * @package ExportArticleFamily\Mapper
 */
class ArtikelFamilie extends Object
{
    /**
     * @var ObjectArtikelFamilie
     */
    private $objectArtikelFamilie;

    /**
     * ArticleFamily constructor.
     *
     * @param ObjectArtikelFamilie $objectArtikelFamilie
     * @param ApplicationLogger    $logger
     */
    public function __construct(ObjectArtikelFamilie $objectArtikelFamilie, ApplicationLogger $logger)
    {
        parent::__construct($logger);
        $this->objectArtikelFamilie = $objectArtikelFamilie;
    }

    /**
     * @return ObjectArtikelFamilie
     */
    public function getObject()
    {
        return $this->objectArtikelFamilie;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {
        return preg_match('/^datenblatt/', $property) || 'localizedfields' == $property  || 'CLPVerordnung' == $property;
    }

    /**
     * Map name to name-id
     *
     * @param $name
     *
     * @return mixed
     */
    public function mapNameId($name)
    {
        return preg_replace('/^datenblatt(multi)?/i', '', $name);
    }
}
