<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Webservice;

use Publikat\Pimcore\ExportArticleFamilyBundle\Model\Request\RequestInterface;
use Publikat\Pimcore\ExportArticleFamilyBundle\Model\Response\ResponseInterface;
use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Client as ClientConfig;
use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Service as ServiceConfig;
use GuzzleHttp\Client as GuzzleClient;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\ExportArticleFamilyBundle\Webservice\Response as Response;

/**
 * Webservice-Request
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Webservice
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Request
{
    /**
     * @var Serializer
     */
    protected $serializer;

    /**
     * @var ApplicationLogger
     */
    protected $logger;

    /**
     * @var GuzzleClient
     */
    protected $guzzleClient;

    /**
     * @var \Publikat\Pimcore\ExportArticleFamilyBundle\Webservice\Response
     */
    protected $response;

    /**
     * Request constructor.
     *
     * @param ApplicationLogger                                               $logger
     * @param GuzzleClient                                                    $guzzleClient
     * @param \Publikat\Pimcore\ExportArticleFamilyBundle\Webservice\Response $response
     */
    public function __construct(ApplicationLogger $logger, GuzzleClient $guzzleClient, Response $response)
    {
        $this->logger = $logger;
        $this->guzzleClient = $guzzleClient;
        $this->response = $response;
        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * @param RequestInterface $request
     * @param ClientConfig     $client
     * @param ServiceConfig    $service
     *
     * @return ResponseInterface
     * @throws \Exception
     */
    public function send(RequestInterface $request, ClientConfig $client, ServiceConfig $service)
    {
        // Prepare request
        $options = [
            'headers' => [
                'Accept' => $service->getAcceptContentType(),
                'Content-Type' => $service->getContentType()
            ],
            'body' => $this->serializer->serialize($request->getRequest(), $service->getFormat())
        ];

        $this->logger->info(sprintf('Object export: sending request to client "%s" url %s', $client->getId(), $service->getUrl()));
        $this->logger->debug($options['body']);

        // Send request
        try {
            $webserviceResponse = $this->guzzleClient->post($service->getUrl(), $options);
        } catch (\Guzzle\Http\Exception\RequestException $exception) {

            // Received an error response
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getRequest()->getResponse());
        } catch (\GuzzleHttp\Exception\ClientException $exception) {

            // Received an error response
            return $this->response->receive($client, $service, $request, $exception->getResponse());
        }

        // Received response
        return $this->response->receive($client, $service, $request, $webserviceResponse);
    }
}
