<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Client;

use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Client;
use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Service;
use Publikat\Pimcore\ExportArticleFamilyBundle\Config\InvalidConfigException;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;

/**
 * Class Manager
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Client
 */
class Manager
{
    /**
     * @var array|\JMS\Serializer\scalar|mixed|object
     */
    protected $pluginConfig;

    /**
     * @var Serializer
     */
    protected $serializer;

    /**
     * Manager constructor.
     */
    public function __construct()
    {
        /*
         * Tried to auto-wire Serializer without creating instance using SerializerBuilder.
         * Didn't get it wo work, so we decided to use static way again...
         */
        $this->serializer = SerializerBuilder::create()->build();
        $this->pluginConfig = $this->serializer->deserialize(
            file_get_contents(__DIR__ . '/../Resources/config/config.' . \Pimcore\Config::getEnvironment() . '.xml'),
            'Publikat\Pimcore\ExportArticleFamilyBundle\Config\PluginConfig',
            'xml'
        );
    }

    /**
     * Get list of configured clients
     *
     * @return Client[]
     */
    public function configured()
    {
        return $this->pluginConfig->getClients();
    }

    /**
     * Get list of active clients
     *
     * @param string $clientId Set client-id, if list should be filtered to one client
     *
     * @return ArrayCollection
     */
    public function active($clientId = null)
    {
        $clients = new ArrayCollection();
        foreach ($this->pluginConfig->getClients() as $client) {
            if ($client->isActive() && (null == $clientId || $client->getId() == $clientId)) {
                $clients[] = $client;
            }
        }
        return $clients;
    }

    /**
     * Get service from service list depending on service name
     *
     * @param Client $client
     * @param string $serviceName
     *
     * @return Service
     * @throws InvalidConfigException
     */
    public function service(Client $client, $serviceName)
    {
        foreach ($client->getServices() as $service) {
            if ($serviceName == $service->getName()) {
                return $service;
            }
        }
        throw new InvalidConfigException(sprintf('Cannot find service configuration for %s', $serviceName));
    }
}
