<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Worker;

use MuleMessageBufferBundle\Event\MuleMessageBufferEvent;
use Pimcore\Event\Model\DataObjectEvent;
use Pimcore\Log\ApplicationLogger;
use Pimcore\Model\Object\ArtikelFamilie;
use Publikat\Pimcore\ExportArticleFamilyBundle\Model\Mule\ArticleFamilyChange;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * Class Mule
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Worker
 */
class Mule
{
    /**
     * @var SerializerInterface
     */
    protected $serializer;

    /**
     * @var EventDispatcher
     */
    private $eventDispatcher;

    /**
     * @var ApplicationLogger
     */
    protected $logger;

    /**
     * Mule constructor.
     *
     * @param SerializerInterface $serializer
     * @param EventDispatcher     $eventDispatcher
     * @param ApplicationLogger   $logger
     */
    public function __construct(
        SerializerInterface $serializer,
        EventDispatcher $eventDispatcher,
        ApplicationLogger $logger
    ) {
        $this->serializer = $serializer;
        $this->eventDispatcher = $eventDispatcher;
        $this->logger = $logger;
    }

    public function run(DataObjectEvent $event)
    {
        if (!class_exists('\\MuleMessageBufferBundle\\Event\\MuleMessageBufferEvent')) {
            $this->logger->debug('Mule Message Buffer not available, can not send Familientext changes');
            return;
        }

        /** @var ArtikelFamilie $object */
        $object = $event->getObject();
        $versionCount = $object->getVersionCount();
        if (!$object->isPublished() || $event->hasArgument('saveVersionOnly') || $versionCount < 2) {
            return;
        }

        /** @var ArtikelFamilie $previousObject */
        $versions = $object->getVersions();
        $previousVersion = $versions[$versionCount - 2];
        $previousObject = $previousVersion->getData();

        if ($object->getArtikelFamilieLangtextStylefile('de') !== $previousObject->getArtikelFamilieLangtextStylefile('de')) {
            $articleFamilyChange = new ArticleFamilyChange();
            $articleFamilyChange
                ->setArticleFamilyId($object->getDisplayCode())
                ->setTextAvailable(!empty($object->getArtikelFamilieLangtextStylefile('de')));

            $data = $this->serializer->serialize($articleFamilyChange, 'json');
            $event = new MuleMessageBufferEvent($data, 'ArticleFamilyChange');
            $this->eventDispatcher->dispatch(MuleMessageBufferEvent::NAME, $event);
        }
    }
}
