<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Config;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Config
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("ExportArticleFamily")
 */
class PluginConfig
{
    /**
     * @Serializer\SerializedName("Clients")
     * @Serializer\Type("ArrayCollection<Publikat\Pimcore\ExportArticleFamilyBundle\Config\Client>")
     * @Serializer\XmlList(inline = false, entry = "Client")
     * @var ArrayCollection
     */
    private $clients;

    /**
     * @Serializer\SerializedName("Objects")
     * @Serializer\Type("Publikat\Pimcore\ExportArticleFamilyBundle\Config\Objects")
     * @var Objects
     */
    private $objects;

    /**
     * @return ArrayCollection
     */
    public function getClients()
    {
        return $this->clients;
    }

    /**
     * @return Objects
     */
    public function getObjects()
    {
        return $this->objects;
    }
}
