<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\EventListener;

use Pimcore\Event\Model\ElementEventInterface;
use Publikat\Pimcore\ExportArticleFamilyBundle\Worker\Delete as DeleteWorker;
use Publikat\Pimcore\ExportArticleFamilyBundle\Worker\Update as UpdateWorker;
use Publikat\Pimcore\ExportArticleFamilyBundle\Worker\Mule as MuleWorker;
use Pimcore\Model\Object\ArtikelFamilie as ArtikelFamilie;

/**
 * Class DataObjectListener
 *
 * @author  Jochen Califice <jc@life-style.de>
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\EventListener
 */
class DataObjectListener
{
    /**
     * @var UpdateWorker
     */
    protected $updateWorker;

    /**
     * @var DeleteWorker
     */
    protected $deleteWorker;

    /**
     * @var MuleWorker
     */
    protected $muleWorker;

    /**
     * DataObjectListener constructor.
     *
     * @param UpdateWorker $updateWorker
     * @param DeleteWorker $deleteWorker
     * @param MuleWorker   $muleWorker
     */
    public function __construct(
        UpdateWorker $updateWorker,
        DeleteWorker $deleteWorker,
        MuleWorker $muleWorker
    ) {
        $this->updateWorker = $updateWorker;
        $this->deleteWorker = $deleteWorker;
        $this->muleWorker = $muleWorker;
    }

    /**
     * @param ElementEventInterface $event
     *
     * @throws \Publikat\Pimcore\ExportArticleFamilyBundle\Config\InvalidConfigException
     */
    public function onPostUpdate(ElementEventInterface $event) {
        if ($event->getObject() instanceof ArtikelFamilie) {
            $this->updateWorker->run($event);
            $this->muleWorker->run($event);

            if (!$event->getObject()->isPublished()) {
                $this->deleteWorker->run($event);
            }
        }
    }

    /**
     * @param ElementEventInterface $event
     *
     * @throws \Publikat\Pimcore\ExportArticleFamilyBundle\Config\InvalidConfigException
     */
    public function onPostDelete(ElementEventInterface $event)
    {
        if ($event->getObject() instanceof ArtikelFamilie) {
            $this->deleteWorker->run($event);
        }
    }
}