<?php
/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Pimcore;

use Pimcore\Config as PimcoreConfig;

/**
 * Pimcore Configuration
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Pimcore
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Config
{
    /**
     * @return string
     * @throws \Exception
     */
    public function getDefaultLanguage()
    {
        return empty(PimcoreConfig::getSystemConfig()->general->defaultLanguage) ?
            'en' :
            PimcoreConfig::getSystemConfig()->general->defaultLanguage;
    }

    /**
     * @return array
     * @throws \Exception
     */
    public function getLanguages()
    {
        return isset(PimcoreConfig::getSystemConfig()->general->validLanguages) ?
            explode(',', str_replace(' ', '', PimcoreConfig::getSystemConfig()->general->validLanguages)) :
            [];
    }

    /**
     * @param $language
     *
     * @return array
     * @throws \Exception
     */
    public function getFallbackLanguages($language)
    {
        return isset(PimcoreConfig::getSystemConfig()->general->fallbackLanguages->{$language}) ?
            explode(',', str_replace(' ', '', PimcoreConfig::getSystemConfig()->general->fallbackLanguages->{$language})) :
            [];
    }

    /**
     * @return bool
     * @throws \Exception
     */
    public function isDebugMode()
    {
        return isset(PimcoreConfig::getSystemConfig()->general->debug) && PimcoreConfig::getSystemConfig()->general->debug;
    }
}
