<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Model\Mule;

/**
 * Class ArticleFamilyChange
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Model\Mule
 */
class ArticleFamilyChange
{
    /**
     * @var string
     */
    private $articleFamilyId;

    /**
     * @var bool
     */
    private $textAvailable;

    /**
     * @return string
     */
    public function getArticleFamilyId(): string
    {
        return $this->articleFamilyId;
    }

    /**
     * @param string $articleFamilyId
     *
     * @return ArticleFamilyChange
     */
    public function setArticleFamilyId(string $articleFamilyId): ArticleFamilyChange
    {
        $this->articleFamilyId = $articleFamilyId;

        return $this;
    }

    /**
     * @return bool
     */
    public function isTextAvailable(): bool
    {
        return $this->textAvailable;
    }

    /**
     * @param bool $textAvailable
     *
     * @return ArticleFamilyChange
     */
    public function setTextAvailable(bool $textAvailable): ArticleFamilyChange
    {
        $this->textAvailable = $textAvailable;

        return $this;
    }
}
