<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Model\Request\Objects\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Request-Node
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Model\Request\Objects\Delete
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     * @Serializer\SerializedName("ProductId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $productId = '';

    /**
     * Set ProductId
     *
     * @param string $productId
     *
     * @return Item
     */
    public function setProductId($productId)
    {

        $this->productId = (string) $productId;

        return $this;
    }

}
