<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\ValueMapper;

use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Client;

/**
 * Unit Mapper Factory
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\ValueMapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * @var array
     */
    private $factory = [];

    /**
     * @var ApplicationLogger
     */
    protected $logger;

    /**
     * Factory constructor.
     *
     * @param ApplicationLogger $logger
     */
    public function __construct(ApplicationLogger $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @param Client $client
     *
     * @return mixed|Area
     * @throws InvalidUnitException
     */
    public function area(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Area($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Length
     * @throws InvalidUnitException
     */
    public function length(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Length($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|LuminousFlux
     * @throws InvalidUnitException
     */
    public function luminousFlux(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new LuminousFlux($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Mass
     * @throws InvalidUnitException
     */
    public function mass(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Mass($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Power
     * @throws InvalidUnitException
     */
    public function power(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Power($client));
    }

    /**
     * @param Client $client
     *
     * @return Format
     */
    public function format(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Format($client, $this->logger));
    }

    /**
     * @param Client $client
     *
     * @return mixed|ElectricCharge
     * @throws InvalidUnitException
     */
    public function electricCharge(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new ElectricCharge($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Energy
     * @throws InvalidUnitException
     */
    public function energy(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Energy($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Temperature
     * @throws InvalidUnitException
     */
    public function temperature(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Temperature($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Time
     * @throws InvalidUnitException
     */
    public function time(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Time($client));
    }

    /**
     * @param Client $client
     *
     * @return mixed|Voltage
     * @throws InvalidUnitException
     */
    public function voltage(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Voltage($client));
    }

    /**
     * @param Client $client
     *
     * @return NumberFormat
     */
    public function numberFormat(Client $client)
    {
        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new NumberFormat($client, $this->logger));
    }
}
