<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\ValueMapper;

use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Client;
use Publikat\Pimcore\ExportArticleFamilyBundle\Config\Objects\Property as ConfigProperty;
use Publikat\Pimcore\ExportArticleFamilyBundle\Mapper\ArtikelFamilie as ObjectMapper;

/**
 * Class LuminousFlux unit mapper (lm, lumen)
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\ValueMapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class LuminousFlux extends Base
{
    /**
     * @var string
     */
    private $baseUnit;

    /**
     * LuminousFlux constructor.
     *
     * @param Client $client
     *
     * @throws InvalidUnitException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);
        $this->validUnits = array(
            'lm' => 'lm',
            'lumen' => 'lm',
        );
        $this->baseUnit = $this->getUnit($client->getUnits()->getLuminousFlux()->getBase());
    }

    /**
     * @param ObjectMapper   $objectMapper
     * @param ConfigProperty $property
     * @param string         $language
     *
     * @return int|mixed|string
     * @throws InvalidPropertyException
     * @throws InvalidValueException
     */
    public function map(ObjectMapper $objectMapper, ConfigProperty $property, $language)
    {
        $value = trim($this->getObjectValue($objectMapper, $property));

        // Do not map empty values
        if (!strlen($value)) {
            return '';
        }
        return (integer) preg_replace('/[^\d]+/', '', $value);
    }
}
