<?php
/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Mapper;

use Pimcore\Log\ApplicationLogger;
use Pimcore\Model\Object\ArtikelFamilie as ObjectArtikelFamilie;
use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;

/**
 * Factory for Mapper
 *
 * @package ExportArticleFamily\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * @var ApplicationLogger
     */
    protected $logger;

    /**
     * Factory constructor.
     *
     * @param ApplicationLogger $applicationLogger
     */
    public function __construct(ApplicationLogger $applicationLogger)
    {
        $this->logger = $applicationLogger;
    }

    /**
     * @param ObjectFieldcollection $objectFieldCollection
     *
     * @return FieldCollection
     */
    public function fieldCollection(ObjectFieldcollection $objectFieldCollection)
    {
        return new FieldCollection($objectFieldCollection);
    }

    /**
     * @param ObjectArtikelFamilie $objectArtikelFamilie
     *
     * @return ArtikelFamilie
     */
    public function artikelFamilie(ObjectArtikelFamilie $objectArtikelFamilie)
    {
        return new ArtikelFamilie($objectArtikelFamilie, $this->logger);
    }
}
