<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Worker;

use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\ExportArticleFamilyBundle\Model\Request\Objects\Delete\Request;
use Publikat\Pimcore\ExportArticleFamilyBundle\Client\Manager as ClientManager;
use Publikat\Pimcore\ExportArticleFamilyBundle\Model\Request\Objects\Delete\Factory as ObjectsDeleteFactory;
use Publikat\Pimcore\ExportArticleFamilyBundle\Webservice\Request as WebserviceRequest;
use Pimcore\Event\Model\DataObjectEvent;

/**
 * Delete Worker
 *
 * @package ExportArticleFamily\Worker
 */
class Delete
{
    /**
     * @var ApplicationLogger
     */
    protected $logger;

    /**
     * @var ObjectsDeleteFactory
     */
    protected $objectsDeleteFactory;

    /**
     * @var ClientManager
     */
    protected $clientManager;

    /**
     * @var WebserviceRequest
     */
    protected $webserviceRequest;

    /**
     * Delete constructor.
     *
     * @param ApplicationLogger    $logger
     * @param ObjectsDeleteFactory $objectsDeleteFactory
     * @param ClientManager        $clientManager
     * @param WebserviceRequest    $webserviceRequest
     */
    public function __construct(
        ApplicationLogger $logger,
        ObjectsDeleteFactory $objectsDeleteFactory,
        ClientManager $clientManager,
        WebserviceRequest $webserviceRequest
    )
    {
        $this->logger = $logger;
        $this->objectsDeleteFactory = $objectsDeleteFactory;
        $this->clientManager = $clientManager;
        $this->webserviceRequest = $webserviceRequest;
    }

    /**
     * @param DataObjectEvent $event
     *
     * @throws \Publikat\Pimcore\ExportArticleFamilyBundle\Config\InvalidConfigException
     */
    public function run(DataObjectEvent $event)
    {
        $object = $event->getObject();
        $modelRequest = $this->objectsDeleteFactory->request();

        // Prepare data
        $this->delete($modelRequest, $object);

        $this->logger->debug(sprintf('Object "%s" (ID: %d) added to delete request',
            $object->getKey(),
            $object->getId()));

        // Send request
        foreach ($this->clientManager->active() as $client) {
            $service = $this->clientManager->service($client, 'Objects::Delete');
            $this->webserviceRequest->send($modelRequest, $client, $service);
        }
    }

    /**
     * @param Request        $request
     * @param ArtikelFamilie $object
     */
    private function delete(Request $request, ArtikelFamilie $object)
    {
        $item = $this->objectsDeleteFactory->item($request);
        $item->setProductId($object->getKey());
    }
}
