<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportArticleFamily\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Unit Tests
 *
 * @package ExportObjects\Tests
 * @author  Oliver Friedrich <of@life-style.de>
 */
class ManagerTest extends TestBase
{

    /**
     * Test instances
     */
    public function testApiManager()
    {

        $this->assertInstanceOf('ExportArticleFamily\Client\Manager', $this->apiM()->clients());
        $this->assertInstanceOf('ExportArticleFamily\Config\PluginConfig', $this->apiM()->pluginConfig());
        $this->assertInstanceOf('ExportArticleFamily\EventListener\Manager', $this->apiM()->eventListener());
        $this->assertInstanceOf('ExportArticleFamily\Mapper\Factory', $this->apiM()->mapper());
        $this->assertInstanceOf('ExportArticleFamily\Model\Manager', $this->apiM()->model());
        $this->assertInstanceOf('ExportArticleFamily\ValueMapper\Manager', $this->apiM()->valuemapper());
        $this->assertInstanceOf('ExportArticleFamily\Pimcore\Manager', $this->apiM()->pimcore());
        $this->assertInstanceOf('ExportArticleFamily\Translate\Manager', $this->apiM()->translate());
        $this->assertInstanceOf('ExportArticleFamily\Webservice\Manager', $this->apiM()->webservice());
        $this->assertInstanceOf('ExportArticleFamily\Worker\Manager', $this->apiM()->worker());
        $this->assertInstanceOf('Zend_Log', $this->apiM()->logger());
        $this->assertInstanceOf('JMS\Serializer\Serializer', $this->apiM()->serializer());
    }

    /**
     * @expectedException \ExportArticleFamily\Config\InvalidConfigException
     */
    public function testClientManager()
    {

        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $this->apiM()->clients()->configured());
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $this->apiM()->clients()->active());
        if ($this->apiM()->clients()->active()->count()) {
            $client = $this->apiM()->clients()->active()->first();
            $this->assertInstanceOf('ExportArticleFamily\Config\Client', $client);
        }
        if ($this->apiM()->clients()->configured()->count()) {
            $client = $this->apiM()->clients()->configured()->first();
            $this->assertInstanceOf('ExportArticleFamily\Config\Client', $client);
            $service = $this->apiM()->clients()->service($client, 'Objects::Update');
            $this->assertInstanceOf('ExportArticleFamily\Config\Service', $service);
            $this->apiM()->clients()->service($client, 'UnknownController::UnknownAction');
        }
    }

    /**
     *
     */
    public function testPimcoreManager()
    {

        $this->assertInstanceOf('ExportArticleFamily\Pimcore\Config', $this->apiM()->pimcore()->config());
    }

    /**
     *
     */
    public function testModelManager()
    {

        $this->assertInstanceOf('ExportArticleFamily\Model\Request\Objects\Delete\Factory', $this->apiM()->model()->objectsDelete());
        $this->assertInstanceOf('ExportArticleFamily\Model\Request\Objects\Update\Factory', $this->apiM()->model()->objectsUpdate());
    }

    /**
     *
     */
    public function testWebserviceManager()
    {

        $this->assertInstanceOf('ExportArticleFamily\Webservice\Request', $this->apiM()->webservice()->request());
        $this->assertInstanceOf('ExportArticleFamily\Webservice\Response', $this->apiM()->webservice()->response());
    }

    /**
     *
     */
    public function testWorkerManager()
    {

        $this->assertInstanceOf('ExportArticleFamily\Worker\Delete', $this->apiM()->worker()->delete());
        $this->assertInstanceOf('ExportArticleFamily\Worker\Update', $this->apiM()->worker()->update());
    }
}
