<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Api;

use ExportArticleFamily\EventListener\Manager as EventListenerManager;
use ExportArticleFamily\Worker\Manager as WorkerManager;
use ExportArticleFamily\Client\Manager as ClientManager;
use ExportArticleFamily\Pimcore\Manager as PimcoreManager;
use ExportArticleFamily\Mapper\Factory as MapperFactory;
use ExportArticleFamily\Model\Manager as ModelManager;
use ExportArticleFamily\Translate\Manager as TranslateManager;
use ExportArticleFamily\ValueMapper\Manager as ValueMapperManager;
use ExportArticleFamily\Webservice\Manager as WebserviceManager;
use ExportArticleFamily\Config\PluginConfig;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Zend_Log as Logger;
use Zend_Log_Writer_Stream as LogWriter;
use Zend_Log_Filter_Priority as LogFilter;

// For the next release of PimCore
//use Pimcore\Log\Log as Logger;
//use Pimcore\Log\Writer\Stream as LogWriter;

/**
 * Api-Manager
 *
 * @package ExportArticleFamily\Api
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{

    /**
     *
     * @var array
     */
    private $factory = array();

    /**
     * @return EventListenerManager
     */
    public function eventListener()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new EventListenerManager($this));
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return ClientManager
     */
    public function clients()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ClientManager($this));
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }

    /**
     * @return MapperFactory
     */
    public function mapper()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new MapperFactory($this));
    }

    /**
     * @return ValueMapperManager
     */
    public function valuemapper()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ValueMapperManager($this));
    }

    /**
     * @return ModelManager
     */
    public function model()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelManager($this));
    }

    /**
     * @return TranslateManager
     */
    public function translate()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslateManager($this));
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WebserviceManager($this));
    }

    /**
     * @return Logger
     */
    public function logger()
    {

        if (!isset($this->factory[__FUNCTION__])) {
            $logWriter = new LogWriter(PIMCORE_LOG_DIRECTORY . '/articleFamily-export.log');
            $logWriter->addFilter(new LogFilter((int) max(\Logger::getPriorities())));
            $this->factory[__FUNCTION__] = new Logger($logWriter);
        }

        return $this->factory[__FUNCTION__];

        // The next release of PimCore will make it easier!
//        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Logger(new LogWriter(PIMCORE_LOG_DIRECTORY . '/object-export.log', null, max(\Logger::getPriorities()))));
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = $this->serializer()->deserialize(file_get_contents(__DIR__ . '/../../../config.xml'),
            'ExportArticleFamily\Config\PluginConfig', 'xml'));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }
}
