<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Config;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Config
 *
 * @package ExportArticleFamily\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("ExportArticleFamily")
 */
class PluginConfig
{
    /**
     * @Serializer\SerializedName("Clients")
     * @Serializer\Type("ArrayCollection<ExportArticleFamily\Config\Client>")
     * @Serializer\XmlList(inline = false, entry = "Client")
     * @var ArrayCollection
     */
    private $clients;

    /**
     * @Serializer\SerializedName("Objects")
     * @Serializer\Type("ExportArticleFamily\Config\Objects")
     * @var Objects
     */
    private $objects;

    /**
     * @return Client[]
     */
    public function getClients()
    {

        return $this->clients;
    }

    /**
     * @return Objects
     */
    public function getObjects()
    {

        return $this->objects;
    }

}
