<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\Mapper;

use ExportArticleFamily\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\Datenblatt as ObjectDatenblatt;

/**
 * Mapper for project specific Object "Datenblatt"
 *
 * @package ExportArticleFamily\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Datenblatt extends Object
{
    /**
     * @var ObjectDatenblatt
     */
    private $objectDatenblatt;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM, ObjectDatenblatt $objectDatenblatt)
    {

        parent::__construct($apiM);
        $this->objectDatenblatt = $objectDatenblatt;
    }

    /**
     * @return ObjectDatenblatt
     */
    public function getObject()
    {

        return $this->objectDatenblatt;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {

        return preg_match('/^datenblatt/', $property) || 'localizedfields' == $property;
    }

    /**
     * Map name to name-id
     *
     * @param $name
     *
     * @return mixed
     */
    public function mapNameId($name)
    {

        return preg_replace('/^datenblatt(multi)?/i', '', $name);
    }

}
