<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportArticleFamily\ValueMapper;

use ExportArticleFamily\Api\Manager as ApiManager;
use ExportArticleFamily\Config\Client;

/**
 * Unit Mapper Manager
 *
 * @package ExportArticleFamily\ValueMapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * Unit-Manager constructor.
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * @param Client $client
     *
     * @return Area
     */
    public function area(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Area($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Length
     */
    public function length(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Length($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return LuminousFlux
     */
    public function luminousFlux(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new LuminousFlux($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Mass
     */
    public function mass(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Mass($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Power
     */
    public function power(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Power($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Format
     */
    public function format(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Format($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return ElectricCharge
     */
    public function electricCharge(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new ElectricCharge($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Energy
     */
    public function energy(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Energy($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Temperature
     */
    public function temperature(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Temperature($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Time
     */
    public function time(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Time($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Voltage
     */
    public function voltage(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new Voltage($this->apiM, $client));
    }

    /**
     * @param Client $client
     *
     * @return Format
     */
    public function numberFormat(Client $client)
    {

        return isset($this->factory[__FUNCTION__ . $client->getId()]) ? $this->factory[__FUNCTION__ . $client->getId()] : ($this->factory[__FUNCTION__ . $client->getId()] = new NumberFormat($this->apiM, $client));
    }
}
