<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportArticleFamilyBundle\Translate;

use Publikat\Pimcore\ExportArticleFamilyBundle\Pimcore\Config as ExportArticleFamilyPimcoreConfig;
use Pimcore\Model\DataObject\AttributUebersetzung\Listing as AttributUebersetzungListing;
use Pimcore\Model\DataObject\AttributUebersetzung;
use Symfony\Component\Translation\Translator as CoreTranslator;
use Symfony\Component\Translation\MessageSelector as CoreMessageSelector;
use Symfony\Component\Translation\Loader\ArrayLoader as CoreArrayLoader;

/**
 * Translator
 *
 * @package Publikat\Pimcore\ExportArticleFamilyBundle\Translate
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Translator
{
    /**
     * @var CoreTranslator
     */
    private $translator;

    /**
     * @var ExportArticleFamilyPimcoreConfig
     */
    protected $exportArticleFamilyPimcoreConfig;

    /**
     * Translator constructor.
     *
     * @param ExportArticleFamilyPimcoreConfig $exportArticleFamilyPimcoreConfig
     */
    public function __construct(ExportArticleFamilyPimcoreConfig $exportArticleFamilyPimcoreConfig)
    {
        $this->exportArticleFamilyPimcoreConfig = $exportArticleFamilyPimcoreConfig;
    }

    /**
     * Translate message
     *
     * @param $message
     *
     * @return string
     * @throws \Exception
     */
    public function trans($message)
    {
        $translated = $this->translator()->trans(strtolower($message));

        return empty($translated) ? $message : $translated;
    }

    /**
     * @return array|CoreTranslator
     * @throws \Exception
     */
    public function translator()
    {
        return null !== $this->translator ? $this->translator : ($this->translator = $this->createTranslator());
    }

    /**
     * @return CoreTranslator
     * @throws \Exception
     */
    private function createTranslator()
    {
        $defaultLanguage = $this->exportArticleFamilyPimcoreConfig->getDefaultLanguage();
        $translator = new CoreTranslator($defaultLanguage, new CoreMessageSelector());
        $translator->addLoader('array', new CoreArrayLoader());

        $translations = [];

        $attributes = new AttributUebersetzungListing();
        foreach ($attributes as $attribute) {
            foreach ($this->exportArticleFamilyPimcoreConfig->getLanguages() as $language) {
                /* @var AttributUebersetzung $attribute */
                $attribute->isPublished() ? $translations[$language][strtolower($attribute->getKey())] = $attribute->getAttributUebersetzungText($language) : null;
            }
        }

        foreach ($translations as $language => $translation) {
            $translator->addResource('array', $translation, $language);
        }

        $translator->setFallbackLocales($this->exportArticleFamilyPimcoreConfig->getFallbackLanguages($defaultLanguage));
        return $translator;
    }

    /**
     * @param $locale
     *
     * @return $this
     * @throws \Exception
     */
    public function setLocale($locale)
    {
        $this->translator()->setLocale($locale);
        $this->translator()->setFallbackLocales($this->exportArticleFamilyPimcoreConfig->getFallbackLanguages($locale));
        return $this;
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function getLocale()
    {
        return $this->translator()->getLocale();
    }
}
